import threading
import getpass  # Zum sicheren Eingeben des Passworts
from datetime import datetime, timedelta

class Bankkonto:
    def __init__(self):
        self.kontostand = 10000.0  # Beispielkontostand
        self.heute_abhebungen = 2000.0  # Maximalbetrag, der heute abgehoben werden kann
        self.transaktionen = []
        self.ist_angemeldet = False
        self.ist_timer_laeuft = False
        self.timer_startzeit = None
        self.sprache = "deutsch"  # Standardmäßig Deutsch

    def login(self):
        """Meldet den Benutzer an, wenn die Anmeldedaten korrekt sind."""
        versuche = 0
        while versuche < 3:
            kunden_id = input(self.text("Kunden-ID: ", "Customer ID: "))
            passwort = getpass.getpass(self.text("Passwort: ", "Password: "))

            if kunden_id == "kunde" and passwort == "passwort":
                self.ist_angemeldet = True
                self.ist_timer_laeuft = True
                self.timer_startzeit = datetime.now()
                return True
            else:
                versuche += 1
                if self.sprache == "deutsch":
                    print(f"Falsche Anmeldedaten. ({3 - versuche} Versuche verbleibend)")
                elif self.sprache == "englisch":
                    print(f"Incorrect login details. ({3 - versuche} attempts remaining)")

        print(self.text("Ihr Konto wurde gesperrt.", "Your account has been locked."))
        return False

    def pin_abfragen(self):
        """Fragt nach der PIN für sicherheitsrelevante Transaktionen und sperrt das Konto nach dreimal falscher Eingabe."""
        versuche = 0
        while versuche < 3:
            pin = input(self.text("Bitte geben Sie Ihre 4-stellige PIN ein: ", "Please enter your 4-digit PIN: "))
            if pin.isdigit() and len(pin) == 4:
                if pin == "0000":  # Richtige PIN
                    return True
                else:
                    versuche += 1
                    verbleibende_versuche = 3 - versuche
                    print(self.text(f"Falsche PIN. ({verbleibende_versuche} Versuche verbleibend)", f"Incorrect PIN. ({verbleibende_versuche} attempts remaining)"))
            else:
                print(self.text("Die PIN muss genau 4 Ziffern haben.", "The PIN must be exactly 4 digits."))

        print(self.text("Ihr Konto wurde gesperrt.", "Your account has been locked."))
        exit()

    def timer(self):
        """Startet einen Timer, der den Benutzer nach 3 Minuten ohne Aktivität abmeldet."""
        while self.ist_timer_laeuft:
            elapsed_time = datetime.now() - self.timer_startzeit
            if elapsed_time >= timedelta(minutes=3):
                self.abmelden()
                return
            threading.Event().wait(60)

    def abmelden(self):
        """Meldet den Benutzer ab und stoppt den Timer."""
        self.ist_angemeldet = False
        self.ist_timer_laeuft = False
        print(self.text("\nSie wurden erfolgreich abgemeldet.", "\nYou have been successfully logged out."))

    def kontostand_anzeigen(self):
        """Gibt den aktuellen Kontostand und den verfügbaren Betrag aus."""
        verfuegbarer_betrag = self.kontostand - self.heute_abhebungen
        kontostand_text = f"{self.kontostand:.2f} €"
        verfuegbarer_betrag_text = f"{verfuegbarer_betrag:.2f} €"
        print(self.text(f"Ihr Kontostand beträgt: {kontostand_text}.", f"Your account balance is: {kontostand_text}."))
        print(self.text(f"Verfügbarer Betrag: {verfuegbarer_betrag_text}.", f"Available balance: {verfuegbarer_betrag_text}."))

    def auszahlen(self):
        """Verarbeitet die Auszahlung von Geldbeträgen."""
        if not self.pin_abfragen():
            return

        verfuegbare_betraege = [5, 10, 25, 50, 100, 200, 500]
        print(self.text("Verfügbare Beträge zur Auszahlung: ", "Available amounts for withdrawal: "))
        for i, betrag in enumerate(verfuegbare_betraege):
            print(f"{i + 1}: {betrag} €")
        print(f"{len(verfuegbare_betraege) + 1}: {self.text('Eigenen Betrag eingeben', 'Enter custom amount')}")

        while True:
            try:
                auswahl = int(input(self.text("Bitte wählen Sie einen Betrag (1-8): ", "Please select an amount (1-8): "))) - 1
                if 0 <= auswahl < len(verfuegbare_betraege):
                    betrag = verfuegbare_betraege[auswahl]
                elif auswahl == len(verfuegbare_betraege):
                    # Benutzer gibt einen eigenen Betrag ein
                    betrag_input = input(self.text("Bitte geben Sie den Betrag in 5 € Schritten ein: ", "Please enter the amount in increments of 5 €: ")).replace(",", ".")
                    betrag = float(betrag_input)  # Hier wird der Betrag korrekt als Float interpretiert
                    if betrag % 5 != 0 or betrag <= 0:
                        print(self.text("Der Betrag muss in 5 € Schritten eingegeben werden.", "The amount must be entered in increments of 5 €."))
                        continue
                else:
                    print(self.text("Ungültige Auswahl.", "Invalid selection."))
                    continue

                if betrag > self.kontostand or betrag > self.heute_abhebungen:
                    print(self.text("Unzureichender Kontostand oder Abhebungen.", "Insufficient balance or withdrawals."))
                    return

                self.kontostand -= betrag
                self.heute_abhebungen -= betrag
                self.transaktionen.append(("Auszahlung", -betrag, datetime.now()))

                scheine = self.berechne_scheine(betrag)
                print(self.text("Auszahlung erfolgreich. Sie erhalten folgende Scheine:", "Withdrawal successful. You will receive the following notes:"))
                for schein, anzahl in scheine.items():
                    print(f"{anzahl} x {schein} €")
                
                # Verfügbaren Betrag anzeigen nach der Auszahlung
                self.kontostand_anzeigen()
                break
            except ValueError:
                print(self.text("Ungültige Eingabe.", "Invalid input."))

    def berechne_scheine(self, betrag):
        """Berechnet die Anzahl der Scheine für den auszuzahlenden Betrag."""
        scheine = {500: 0, 200: 0, 100: 0, 50: 0, 20: 0, 10: 0, 5: 0}
        for schein in sorted(scheine.keys(), reverse=True):
            while betrag >= schein:
                scheine[schein] += 1
                betrag -= schein
        return {k: v for k, v in scheine.items() if v > 0}

    def letzte_buchungen_anzeigen(self):
        """Zeigt die letzten 6 Buchungen an und den Gesamtbetrag."""
        print(self.text("Letzte Buchungen:", "Recent transactions:"))
        gesamtbetrag = 0
        for transaktion in self.transaktionen[-6:]:
            typ, betrag, datum = transaktion
            gesamtbetrag += betrag
            print(f"{typ}: {betrag:.2f} € am {datum.strftime('%d.%m.%Y %H:%M')}")
        
        gesamtbetrag_text = f"{gesamtbetrag:.2f} €"
        print(self.text(f"Gesamtbetrag der letzten Buchungen: {gesamtbetrag_text}.", f"Total amount of recent transactions: {gesamtbetrag_text}."))

    def einzahlen(self):
        """Verarbeitet die Einzahlung von Geldbeträgen."""
        if not self.ist_angemeldet:
            print(self.text("Bitte zuerst anmelden.", "Please log in first."))
            return

        # PIN-Abfrage für Einzahlungen
        if not self.pin_abfragen():
            return

        while True:
            try:
                betrag = float(input(self.text("Bitte geben Sie den Betrag zur Einzahlung ein: ", "Please enter the deposit amount: ")))
                if betrag <= 0:
                    print(self.text("Der Betrag muss positiv sein.", "The amount must be positive."))
                    continue

                self.kontostand += betrag
                self.transaktionen.append(("Einzahlung", betrag, datetime.now()))
                
                # Kontostand nach Einzahlung anzeigen
                self.kontostand_anzeigen()
                break
            except ValueError:
                print(self.text("Ungültige Eingabe.", "Invalid input."))

    def text(self, deutsch, englisch):
        """Hilfsmethode zur Auswahl des Textes basierend auf der Sprache."""
        return deutsch if self.sprache == "deutsch" else englisch

    def sprache_aendern(self):
        """Ändert die Sprache."""
        print(self.text("\nNeue Sprache wählen (1: Deutsch, 2: Englisch): ", "\nChoose new language (1: German, 2: English): "))
        while True:
            try:
                wahl = int(input())
                if wahl == 1:
                    self.sprache = "deutsch"
                    print(self.text("Sprache auf Deutsch geändert.", "Language changed to German."))
                    break
                elif wahl == 2:
                    self.sprache = "englisch"
                    print(self.text("Sprache auf Englisch geändert.", "Language changed to English."))
                    break
                else:
                    print(self.text("Ungültige Eingabe.", "Invalid input."))
            except ValueError:
                print(self.text("Ungültige Eingabe.", "Invalid input."))

    def hauptmenue(self):
        """Zeigt das Hauptmenü an und verarbeitet die Auswahl."""
        while self.ist_angemeldet:
            print("\n" + self.text("Wählen Sie eine Aktion:", "Choose an action:"))
            print("1. " + self.text("Kontostand anzeigen", "Show account balance"))
            print("2. " + self.text("Auszahlung", "Withdrawal"))
            print("3. " + self.text("Einzahlung", "Deposit"))
            print("4. " + self.text("Letzte Buchungen anzeigen", "Show recent transactions"))
            print("5. " + self.text("Sprache ändern", "Change language"))
            print("6. " + self.text("Beenden", "Log out"))

            try:
                wahl = int(input(self.text("Ihre Wahl: ", "Your choice: ")))
                if wahl == 1:
                    self.kontostand_anzeigen()
                elif wahl == 2:
                    self.auszahlen()
                elif wahl == 3:
                    self.einzahlen()
                elif wahl == 4:
                    self.letzte_buchungen_anzeigen()
                elif wahl == 5:
                    self.sprache_aendern()
                elif wahl == 6:
                    self.abmelden()
                    break
                else:
                    print(self.text("Ungültige Auswahl.", "Invalid selection."))
            except ValueError:
                print(self.text("Ungültige Eingabe.", "Invalid input."))


# Hauptprogramm starten:
print("Willkommen beim Finance-Overlay der Ungeplant-Bank!")
print("Entwickler: Lupus-IT © | Version 4.0\n")

# Sprachwahl zu Beginn:
konto = Bankkonto()

while True:
    konto.sprache_aendern()
    if konto.login():
        # Timer in separatem Thread starten
        timer_thread = threading.Thread(target=konto.timer)
        timer_thread.start()

        konto.hauptmenue()
    else:
        break